if {!$::PLAY_OK} {
	return
}

set ::LOGF [open [file join $::SYSTEM_PATH "timed_script_log.txt"] a]

proc log {s {also_forward_to_wife 0}} {
	set timestamp [clock format [clock seconds] -format "%Y%m%d:%H%M%S"]
	if {$::LOGF != ""} {
		puts $::LOGF "$timestamp: $s"
	}
	if {$also_forward_to_wife} {
		wife::send log "$s"
	}
}

set ::CREATE_SHARES_DIR 0
set ::check_folders_newer_than_this [clock scan "-1 week" -base [clock seconds]]
set ::check_folders_older_than_this [clock scan "-30 seconds" -base [clock seconds]]
set ::CHECK_FOLDER_NAMED "TO_CLIENT_NOW"

#log "------------------------------------------------"
#log "Timed script starting..."

lassign [wife::send get_var FILES_HOME] ok ::FILES_HOME error_string
if {!$ok} {
	log "$error_string"
}

#log "Files home: $::FILES_HOME"

set total_time [time {
	play:scan_for_shares
	play:scan_all_synced
}]

#log "Timed Script: Total time: [expr {[lindex $total_time 0] / 1000000.0}] seconds"

if {$::LOGF != ""} {
	close $::LOGF
}
